#
#
# Utility functions
#
#

proc remove_trace var {
global $var
catch {
puts $var
puts [trace vinfo $var]
foreach entry [trace vinfo $var] {
	puts  [lindex $entry 0] 
	trace vdelete $var [lindex $entry 0] [lindex $entry 1]
	}
	}
}
#
#
# global defaults
#
#
font create title_font -size 20


#
# define menu
#
frame .f -bd 0 -relief flat
pack .f -side top -fill x
menubutton .f.file -text File
menubutton .f.help -text Help
pack .f.file  -side left -padx 5
pack .f.help  -side right -padx 5
# File menu
menu .f.file.menu -tearoff 0
.f.file.menu add command -label {New model} -command new_model1
.f.file.menu add command -label {Save model} -command save_model1
.f.file.menu add command -label {Load model} -command load_model1
.f.file.menu add separator
.f.file.menu add command -label Quit -command exit
.f.file config -menu .f.file.menu
# Help menu
menu .f.help.menu -tearoff 0
.f.help.menu add command -label About -command about_box
.f.help config -menu .f.help.menu

proc about_box {} {
toplevel .about 
frame .about.f -bd 0
text   .about.f.text -relief flat -background gray
.about.f.text insert end "Ps-i version 2.0 alpha" title
.about.f.text tag configure title -justify center -font title_font
.about.f.text configure -width 50 -height 4
button .about.f.ok -text "OK" -command { destroy .about }
pack .about.f .about.f.text .about.f.ok
update
}

#define buttons
frame .main 
pack .main 
button .main.ac -text "Agent Class editor" -command ac_editor
grid .main.ac -sticky ew
button .main.f -text "Field editor" -command field_editor
grid .main.f -sticky ew
button .main.r -text "Routine editor" -command routine_editor
grid .main.r -sticky ew
button .main.f_d -text "Field viewer" -command field_viewer
grid .main.f_d -sticky ew

global fn
set fn "test1.mdl"

#
# File operations
#

proc new_model1 {} {
# put a box asking whether the user wants to reset the model
if {[winfo exists .ac_editor]} {
	destroy .ac_editor
	}
reset_model 
}

proc save_model1 {} {
global fn
set fn [tk_getSaveFile -defaultextension {.mdl} -initialfile $fn ]
save_model $fn
}

proc load_model1 {} {
global fn 
set fn [tk_getOpenFile -defaultextension {.mdl} ]
if {[winfo exists .ac_editor]} {
	destroy .ac_editor
	}
load_model $fn
}

#
#  Agent class editor
#

proc add_agent_class1 {} {
set ac [.ac_editor.f.agentclasses get]
add_agentclass $ac
.ac_editor.f.agentclasses listinsert end $ac
display_notebook
}

proc newattr {} {
set ac [.ac_editor.f.agentclasses get]
if { $ac == "" } return
set ac_ind [find_agentclass $ac]
if {$ac_ind <0} return
agentclass_add_attr $ac_ind "Attr_name"
display_notebook
}

proc removeattr i {
set ac [.ac_editor.f.agentclasses get]
if { $ac == "" } return
set ac_ind [find_agentclass $ac]
if {$ac_ind <0} return
agentclass_remove_attr $ac_ind $i
display_notebook 
}

proc set_attr_type {ind attr var a b c} {
global $var
agentclass_set_attr_type $ind $attr [set $var]
}

proc set_attr_name {ind attr var a b c} {
global $var
agentclass_set_attr_name $ind $attr [set $var]
}

proc set_attr_value {ind attr var a b c} {
global $var
agentclass_set_attr_value $ind $attr [set $var]
}

proc display_attr {} {
global attr_w
if {[winfo exists ${attr_w}.f]} {
	destroy ${attr_w}.f
	}
frame ${attr_w}.f -bd 0
pack ${attr_w}.f  -expand yes -side top -fill y
set ac [.ac_editor.f.agentclasses get]
if { $ac == "" } return
set ac_ind [find_agentclass $ac]
if {$ac_ind<0} {
	button ${attr_w}.f.b -text "Add agent class $ac"
	${attr_w}.f.b configure -command add_agent_class1
	pack ${attr_w}.f.b
	return
	}
frame ${attr_w}.f.f
scrollbar ${attr_w}.f.f.vscroll -command "${attr_w}.f.f.c yview"
canvas ${attr_w}.f.f.c -bd 0 -borderwidth 0 \
	-yscrollcommand "${attr_w}.f.f.vscroll set" \
	-scrollregion {0 0 100 100} -height 10
label ${attr_w}.f.f.c.l0 -text "Remove"
label ${attr_w}.f.f.c.l1 -text "Name"
label ${attr_w}.f.f.c.l2 -text "Type"
label ${attr_w}.f.f.c.l3 -text "Value"
grid ${attr_w}.f.f.c.l0 ${attr_w}.f.f.c.l1 ${attr_w}.f.f.c.l2 ${attr_w}.f.f.c.l3
set num_attr [agentclass_num_attr $ac_ind]
if {$num_attr <1} {
	label ${attr_w}.f.f.c.l4 -text "No attributes entered" -foreground red
	grid ${attr_w}.f.f.c.l4 -rowspan 4
	}
for {set i 0} {$i < $num_attr} {incr i} {
	global attrtype$i attrname$i attrvalue$i
	set attrtype$i [agentclass_attr_type $ac_ind $i]
	set attrvalue$i [agentclass_attr_value $ac_ind $i]
	set attrname$i [agentclass_attr_name $ac_ind $i] 
	button ${attr_w}.f.f.c.r$i -text "X"
	${attr_w}.f.f.c.r$i configure -command "removeattr $i"
	entry ${attr_w}.f.f.c.e$i -width 16 -textvariable attrname$i
	remove_trace attrname$i
	trace variable attrname$i w "set_attr_name $ac_ind $i attrname$i"	
	tk_optionMenu ${attr_w}.f.f.c.om$i attrtype$i integer boolean set hash 
	remove_trace attrname$i
	trace variable attrtype$i w "set_attr_type $ac_ind $i attrtype$i"
	combobox::combobox ${attr_w}.f.f.c.v$i -width 8 -textvariable attrvalue$i
	${attr_w}.f.f.c.v$i listinsert end "random"
	remove_trace attrname$i
	trace variable attrvalue$i w "set_attr_value $ac_ind $i attrvalue$i"
	grid ${attr_w}.f.f.c.r$i ${attr_w}.f.f.c.e$i ${attr_w}.f.f.c.om$i ${attr_w}.f.f.c.v$i -padx 2 -pady 1 -sticky ew
	}
pack  ${attr_w}.f.f -side top -fill both 
grid ${attr_w}.f.f.c -sticky news
grid rowconfig ${attr_w}.f.f 0 -weight 1
grid column ${attr_w}.f.f 0 -weight 1
grid ${attr_w}.f.f.vscroll -row 0 -column 1 -sticky ns
button ${attr_w}.f.newattr -text "Add new attribute"
${attr_w}.f.newattr configure -command newattr
button ${attr_w}.f.update -text "Update"
${attr_w}.f.update configure -command display_notebook
pack ${attr_w}.f.newattr ${attr_w}.f.update  -side left -pady 10 
}

global agent_colors n_colors
set agent_colors { magenta yellow red blue green brown }
set n_colors [llength $agent_colors]

proc get_color color {
global agent_colors n_colors
set c [expr $color % $n_colors]
return [lindex $agent_colors $c]
}

proc draw_agent_square {canv x y color1 color2} {
set x1 [expr $x]
set y1 [expr $y]
set x2 [expr $x+30]
set y2 [expr $y+30]
$canv create polygon $x1 $y1 $x1 $y2 $x2 $y2 $x2 $y1 -fill [get_color $color1] -outline black
set x1 [expr $x+10]
set y1 [expr $y+10]
set x2 [expr $x+20]
set y2 [expr $y+20]
$canv create polygon $x1 $y1 $x1 $y2 $x2 $y2 $x2 $y1 -fill [get_color $color2] -outline black
}

proc draw_agent_pentagon {canv x y color1 color2} {
set x1 [expr $x+15]
set y1 [expr $y]
set x2 [expr $x+30]
set y2 [expr $y+10]
set x3 [expr $x+25]
set y3 [expr $y+30]
set x4 [expr $x+5]
set y4 [expr $y+30]
set x5 [expr $x]
set y5 [expr $y+10]
$canv create polygon $x1 $y1 $x2 $y2 $x3 $y3 $x4 $y4 $x5 $y5 -fill [get_color $color1] -outline black
set x1 [expr $x+10]
set y1 [expr $y+12]
set x2 [expr $x+20]
set y2 [expr $y+22]
$canv create polygon $x1 $y1 $x1 $y2 $x2 $y2 $x2 $y1 -fill [get_color $color2] -outline black
}

proc draw_agent_oval {canv x y color1 color2} {
set x1 [expr $x]
set y1 [expr $y]
set x2 [expr $x+30]
set y2 [expr $y+30]
$canv create oval $x1 $y1 $x2 $y2  -fill [get_color $color1] -outline black
set x1 [expr $x+10]
set y1 [expr $y+10]
set x2 [expr $x+20]
set y2 [expr $y+20]
$canv create polygon $x1 $y1 $x1 $y2 $x2 $y2 $x2 $y1 -fill [get_color $color2] -outline black
}

proc draw_agent {canv x y shape color1 color2 } {
switch $shape \
	"Square" "draw_agent_square $canv $x $y $color1 $color2" \
	"Pentagon" "draw_agent_pentagon $canv $x $y $color1 $color2" \
	"Oval" "draw_agent_oval $canv $x $y $color1 $color2"
	
}

proc show_agent {name1 name2 op} {
global disp_w ac_shape
${disp_w}.f.disp delete all
draw_agent ${disp_w}.f.disp 5 5 $ac_shape 2 3
}

proc display_disp {} {
global disp_w ac_shape
if {[winfo exists ${disp_w}.f]} {
	destroy ${disp_w}.f
	}
frame ${disp_w}.f
pack ${disp_w}.f -ipady 10
set ac [.ac_editor.f.agentclasses get]
set ac_ind [find_agentclass $ac]
if {$ac_ind<0} {
	button ${disp_w}.f.b -text "Add agent class $ac"
	${disp_w}.f.b configure -command add_agent_class1
	pack ${disp_w}.f.b
	return
	}

global ac_shape
label ${disp_w}.f.l0 -text "View class:"

combobox::combobox ${disp_w}.f.vc -textvariable view_class
grid ${disp_w}.f.l0 ${disp_w}.f.vc

label ${disp_w}.f.l1 -text "Shape:"
tk_optionMenu ${disp_w}.f.shape  ac_shape "Square" "Pentagon" "Oval" "Star" 
grid ${disp_w}.f.l1 ${disp_w}.f.shape -sticky ew

label ${disp_w}.f.l2 -text "Outer color:"
combobox::combobox ${disp_w}.f.oc -textvariable outer_color

grid ${disp_w}.f.l2 ${disp_w}.f.oc
label ${disp_w}.f.l3 -text "Inner color:"

combobox::combobox ${disp_w}.f.ic -textvariable inner_color
grid ${disp_w}.f.l3 ${disp_w}.f.ic

set numroutines [routines_num]
for {set i 0} {$i<$numroutines} {incr i} {
	${disp_w}.f.ic listinsert end [routine_name $i]
	${disp_w}.f.oc listinsert end [routine_name $i]
	}
canvas ${disp_w}.f.disp -width 40 -height 40 -scrollregion {0 0 40 40} -relief sunken -bd 2
grid ${disp_w}.f.disp -column 3 -row 1 -rowspan 4 -padx 20 
draw_agent ${disp_w}.f.disp 5 5 $ac_shape 2 3
remove_trace ac_shape
trace variable ac_shape w {show_agent}
}

proc display_notebook {} {
display_attr
display_disp
global attrtype0
catch { puts [ trace vinfo attrtype0 ] }
}


proc ac_editor {} {
if {[winfo exists .ac_editor]} {
 raise .ac_editor
 return 
 }
 
toplevel .ac_editor
frame .ac_editor.f -bd 0
label .ac_editor.f.label1 -text "Agent class:"
combobox::combobox  .ac_editor.f.agentclasses -textvariable agent_class
set numagents [ agentclasses_num ]
for {set i 0} {$i<$numagents} {incr i} {
.ac_editor.f.agentclasses listinsert end [ agentclass_name $i ]
}
if {$numagents >0} {
	.ac_editor.f.agentclasses configure -value [agentclass_name 0]
	}
pack .ac_editor.f.label1   -side left
pack .ac_editor.f.agentclasses -side left 
pack .ac_editor.f -fill x -side top
Notebook:create .ac_editor.notebook -pages {Attributes Display}
global attr_w disp_w
pack .ac_editor.notebook  -fill both -expand 1
set attr_w [Notebook:frame .ac_editor.notebook Attributes]
set disp_w [Notebook:frame .ac_editor.notebook Display]
bind .ac_editor.f.agentclasses <<Combobox_change>> display_notebook
bind .ac_editor.notebook <<Notebook_change>> display_notebook 
display_notebook
}

proc field_editor {} {
}

proc routine_editor_redisplay {a b c} {
routine_editor
}

proc r_e_display_builtin r_ind {
global r_e_comment 
label .routine_editor.f.l1 -text "Type:"
label .routine_editor.f.l2 -text "builtin" 
grid .routine_editor.f.l1 .routine_editor.f.l2 -sticky ew
label .routine_editor.f.l3 -text "Comment:" -background black -foreground white
grid .routine_editor.f.l3 - -sticky ew 
frame .routine_editor.f.f
grid .routine_editor.f.f - -sticky news
text .routine_editor.f.f.comment  -foreground blue -state disabled  -height 6 \
	-width 30 -wrap word -yscrollcommand ".routine_editor.f.f.vscroll set"
puts [routine_comment $r_ind]
.routine_editor.f.f.comment insert end [routine_comment $r_ind]
scrollbar .routine_editor.f.f.vscroll -command ".routine_editor.f.f.comment yview"
grid .routine_editor.f.f.comment  -sticky news
grid .routine_editor.f.f.vscroll -column 1 -row 0 -sticky ns
}

proc routine_editor {} {
global r_e_type r_e_comment
if {[winfo exists .routine_editor]} {
	raise .routine_editor
	} else {
	toplevel .routine_editor;
	}
catch { destroy .routine_editor.f }
frame .routine_editor.f
pack .routine_editor.f -fill both -side top -expand yes
label .routine_editor.f.l0 -text "Routine:"
combobox::combobox .routine_editor.f.routine1 -textvariable routine_name
bind .routine_editor.f.routine1 <<Combobox_change>> routine_editor
set numroutines [routines_num]
for {set i 0} {$i<$numroutines} {incr i} {
	.routine_editor.f.routine1 listinsert end [routine_name $i]
	}
grid .routine_editor.f.l0 .routine_editor.f.routine1 -sticky ew
if {[catch { set r_ind [find_routine [.routine_editor.f.routine1 get]] } ] != 0} {
	set r_ind -1
	}
if { $r_ind < 0 } {
	label .routine_editor.f.l1 -text "Type:"
	combobox::combobox .routine_editor.f.type -textvariable r_e_type
	.routine_editor.f.type listinsert end "composite" 
	.routine_editor.f.type listinsert end "customized"
	grid .routine_editor.f.l1 .routine_editor.f.type -sticky ew
	button .routine_editor.f.b -text "Add new routine"
	grid .routine_editor.f.b - -sticky ew
	return
	}
set r_e_type [routine_type $r_ind]
switch $r_e_type \
	"builtin"  "r_e_display_builtin $r_ind"\
	"customized" "r_e_display_customized $r_ind"\
	"composite" "r_e_display_composite $r_ind"\
}

proc field_viewer {} {
if {[winfo exists .field_viewer]} {
	raise .field_viewer
	return	
	}
toplevel .field_viewer
frame .field_viewer.f -bd 0
pack .field_viewer.f -fill both -side top -expand yes
frame .field_viewer.f.f0 -bd 0
pack .field_viewer.f.f0
label .field_viewer.f.f0.l0 -text "Field"
label .field_viewer.f.f0.l1 -text "Display"
set i [model_time]
label .field_viewer.f.f0.l2 -text "Time=$i" -background black -foreground white
grid .field_viewer.f.f0.l0 .field_viewer.f.f0.l1 .field_viewer.f.f0.l2
combobox::combobox .field_viewer.f.f0.field -textvariable f_v_field
combobox::combobox .field_viewer.f.f0.display -textvariable f_v_display
grid .field_viewer.f.f0.field .field_viewer.f.f0.display 
frame .field_viewer.f.f -bd 0 
pack .field_viewer.f.f -side top -fill both -expand yes
canvas .field_viewer.f.f.c -relief sunken -borderwidth 2 \
	-xscrollcommand ".field_viewer.f.f.hscroll set" \
	-yscrollcommand ".field_viewer.f.f.vscroll set" 
scrollbar .field_viewer.f.f.vscroll -command ".field_viewer.f.f.c yview"
scrollbar .field_viewer.f.f.hscroll -orient horiz -command ".field_viewer.f.f.c xview" 
grid .field_viewer.f.f.c -sticky news
grid .field_viewer.f.f.vscroll -row 0 -column 1 -sticky ns
grid .field_viewer.f.f.hscroll -sticky ew
grid rowconfig .field_viewer.f.f 0 -weight 1
grid columnconfig .field_viewer.f.f 0 -weight 1
}

